{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:21:36 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMUtils, MMHTimer, StdCtrls, MMObj, MMCstDlg, MMDIBCv, MMLevel, MMConect,
  MMDesign, MMRingBf, MMDSPObj, MMWavOut, MMWave, ExtCtrls,
  MMHook, MMDSWOut;

type
  TMainForm = class(TForm)
    WaveFile1: TMMWaveFile;
    WaveOut: TMMWaveOut;
    RingBuffer: TMMRingBuffer;
    MMDesigner1: TMMDesigner;
    MMConnector1: TMMConnector;
    Level1: TMMLevel;
    Level2: TMMLevel;
    OpenDialog: TMMWaveOpenDialog;
    btnStart: TButton;
    btnStop: TButton;
    btnFile: TButton;
    Label1: TLabel;
    lblPosition: TLabel;
    Timer: TMMHiTimer;
    PlayListBox: TListBox;
    procedure TimerTimer(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveOutClose(Sender: TObject);
  public
    PlayIndex: integer;
    Stopping: Boolean;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Stopping := True;
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TimerTimer(Sender: TObject);
begin
   lblPosition.Caption := TimeToString(WaveOut.Position);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   Stopping := False;

   PlayIndex := 0;

   WaveFile1.Wave.FileName := PlayListBox.Items[PlayIndex];
   PlayListBox.ItemIndex := PlayIndex;
   inc(PlayIndex);

   WaveOut.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   Stopping := True;
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   Timer.Enabled := True;
   btnFile.Enabled := False;
   btnStart.Enabled := False;
   btnStop.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   Timer.Enabled := False;
   btnFile.Enabled := True;
   btnStart.Enabled := True;
   btnStop.Enabled := False;

   { close the file here so we can go to the next file }
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutClose(Sender: TObject);
begin
   { the files was done... }

   { we should stop playing ! }
   if Stopping then exit;


   { other files to play ??? }
   if PlayIndex < PlayListBox.Items.Count then
   begin
      { set the next file }
      WaveFile1.Wave.FileName := PlayListBox.Items[PlayIndex];
      { update the ListBox }
      PlayListBox.ItemIndex := PlayIndex;
      inc(PlayIndex);

      WaveOut.Start;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   { setup a simple playlist so we can demonstrate how to handle it }
   if OpenDialog.Execute then
   begin
      PlayListBox.Items.Add(OpenDialog.FileName);
      btnStart.Enabled := True;
   end;
end;

end.
